/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains.display;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.foundation.utility.DyeHelper;
import com.zurrtum.create.content.trains.display.FlapDisplayBlock;
import com.zurrtum.create.content.trains.display.FlapDisplayBlockEntity;
import com.zurrtum.create.content.trains.display.FlapDisplayLayout;
import com.zurrtum.create.content.trains.display.FlapDisplaySection;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11603;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11767;
import net.minecraft.class_11768;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1767;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2769;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5223;
import net.minecraft.class_5224;
import net.minecraft.class_5251;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class FlapDisplayRenderer
extends KineticBlockEntityRenderer<FlapDisplayBlockEntity, FlapDisplayRenderState> {
    protected final class_327 textRenderer;

    public FlapDisplayRenderer(class_5614.class_5615 context) {
        super(context);
        this.textRenderer = context.comp_4540();
    }

    @Override
    public FlapDisplayRenderState createRenderState() {
        return new FlapDisplayRenderState();
    }

    @Override
    public void extractRenderState(FlapDisplayBlockEntity be, FlapDisplayRenderState state, float tickProgress, class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlay) {
        super.extractRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        if (!be.isController) {
            return;
        }
        if (state.support) {
            class_11954.method_74399((class_2586)be, (class_11954)state, (class_11683.class_11792)crumblingOverlay);
        }
        FlapDisplayData display = new FlapDisplayData();
        List<FlapDisplayLayout> lines = be.getLines();
        boolean paused = !be.isSpeedRequirementFulfilled();
        class_1937 world = be.method_10997();
        int levelTicks = AnimationTickHolder.getTicks((class_1936)world);
        int ticks = paused ? 0 : levelTicks;
        float time = paused ? 0.0f : AnimationTickHolder.getRenderTime((class_1936)world);
        int size = lines.size();
        float y = 4.5f;
        int light = state.field_62676;
        for (int j = 0; j < size; ++j) {
            List<FlapDisplaySection> line = lines.get(j).getSections();
            int color = FlapDisplayRenderer.getLineColor(be, j);
            float w = 0.0f;
            int count = line.size();
            float[] offsets = new float[count];
            for (int i = 0; i < count; ++i) {
                FlapDisplaySection section = line.get(i);
                offsets[i] = w;
                w += section.getSize() + (float)(section.hasGap ? 8 : 1);
            }
            float margin = (float)(be.xSize * 16) - w / 2.0f + 1.0f;
            boolean glowing = be.isLineGlowing(j);
            FlapDisplayRenderOutput renderOutput = new FlapDisplayRenderOutput(y, this.textRenderer, color, j, paused, ticks, time, glowing, drawable -> display.add(light, glowing, (class_11767)drawable));
            for (int i = 0; i < count; ++i) {
                FlapDisplaySection section = line.get(i);
                renderOutput.nextSection(section, margin + offsets[i]);
                String text = section.renderCharsIndividually() || !section.spinning[0] ? section.text : section.cyclingOptions[(levelTicks / 3 + i * 13) % section.cyclingOptions.length];
                class_5223.method_27479((String)text, (class_2583)class_2583.field_24360, (class_5224)renderOutput);
            }
            y += 16.0f;
        }
        if (display.isEmpty()) {
            return;
        }
        display.yRot = (float)Math.PI / 180 * AngleHelper.horizontalAngle((class_2350)state.field_62674.method_11654((class_2769)FlapDisplayBlock.HORIZONTAL_FACING));
        state.display = display;
    }

    @Override
    public void submit(FlapDisplayRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        super.submit(state, matrices, queue, cameraState);
        if (state.display != null) {
            state.display.render(matrices, queue);
        }
    }

    public static int getLineColor(FlapDisplayBlockEntity be, int line) {
        class_1767 color = be.colour[line];
        return color == null ? -2898246 : (Integer)DyeHelper.getDyeColors(color).getFirst() | 0xFF000000;
    }

    @Override
    protected SuperByteBuffer getRotatedModel(FlapDisplayBlockEntity be, FlapDisplayRenderState state) {
        return CachedBuffers.partialFacingVertical(AllPartialModels.SHAFTLESS_COGWHEEL, state.field_62674, (class_2350)state.field_62674.method_11654((class_2769)FlapDisplayBlock.HORIZONTAL_FACING));
    }

    public boolean method_3563() {
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public static class FlapDisplayRenderState
    extends KineticBlockEntityRenderer.KineticRenderState {
        public FlapDisplayData display;
    }

    @Environment(value=EnvType.CLIENT)
    public static class FlapDisplayData {
        public Map<class_1921, TextRenderState> map = new IdentityHashMap<class_1921, TextRenderState>();
        public float yRot;

        public void add(int light, boolean glowing, class_11767 textDrawable) {
            this.map.computeIfAbsent(textDrawable.method_73401(class_327.class_6415.field_33993), layer -> new TextRenderState(light)).add(glowing, textDrawable);
        }

        public void render(class_4587 matrices, class_11659 queue) {
            matrices.method_22903();
            matrices.method_46416(0.5f, 0.5f, 0.5f);
            matrices.method_22907((Quaternionfc)class_7833.field_40716.rotation(this.yRot));
            matrices.method_46416(-0.5f, 0.5f, 0.3125f);
            matrices.method_22905(0.03125f, -0.03125f, 0.03125f);
            matrices.method_46416(0.0f, 0.0f, 0.5f);
            this.map.forEach((layer, state) -> queue.method_73483(matrices, layer, (class_11659.class_11660)state));
            matrices.method_22909();
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class FlapDisplayRenderOutput
    implements class_5224 {
        final class_327 textRenderer;
        final int color;
        final int r;
        final int g;
        final int b;
        final int a;
        final boolean paused;
        final int ticks;
        final float time;
        final int lineIndex;
        final float y;
        final Consumer<class_11767> consumer;
        FlapDisplaySection section;
        float x;

        public FlapDisplayRenderOutput(float y, class_327 textRenderer, int color, int lineIndex, boolean paused, int ticks, float time, boolean glowing, Consumer<class_11767> consumer) {
            this.y = y;
            this.textRenderer = textRenderer;
            this.lineIndex = lineIndex;
            this.paused = paused;
            this.ticks = ticks;
            this.time = time;
            this.a = glowing ? -134217728 : -671088640;
            this.r = color >> 16 & 0xFF;
            this.g = color >> 8 & 0xFF;
            this.b = color & 0xFF;
            this.color = color;
            this.consumer = consumer;
        }

        public void nextSection(FlapDisplaySection section, float offset) {
            this.section = section;
            this.x = offset;
        }

        public boolean accept(int charIndex, class_2583 style, int glyph) {
            class_11767.class_12238 textDrawable;
            float standardWidth;
            class_5251 textcolor = style.method_10973();
            boolean canDim = textcolor == null;
            boolean dim = false;
            if (this.section.renderCharsIndividually() && this.section.spinning[Math.min(charIndex, this.section.spinning.length)]) {
                float speed = this.section.spinningTicks > 5 && this.section.spinningTicks < 20 ? 1.75f : 2.5f;
                float cycle = this.time / speed + (float)charIndex * 16.83f + (float)this.lineIndex * 0.75f;
                float partial = cycle % 1.0f;
                int cyclingGlyph = this.section.cyclingOptions[(int)cycle % this.section.cyclingOptions.length].charAt(0);
                glyph = this.paused ? cyclingGlyph : (partial > 0.5f ? (partial > 0.75f ? 95 : 45) : cyclingGlyph);
                if (canDim) {
                    dim = true;
                }
            }
            class_11603 glyphProvider = this.textRenderer.method_72732(style.method_27708());
            class_11768 bakedglyph = glyphProvider.method_72736(glyph);
            float glyphWidth = bakedglyph.method_73398().method_16798(false);
            boolean obfuscated = style.method_10987();
            if (!this.section.renderCharsIndividually() && this.section.spinning[0]) {
                if (!obfuscated) {
                    int oldGlyph = glyph;
                    int i = this.ticks % 3;
                    if (i == 0) {
                        if (glyphWidth == 6.0f) {
                            glyph = 45;
                        } else if (glyphWidth == 1.0f) {
                            glyph = 39;
                        }
                    } else if (i == 2) {
                        if (glyphWidth == 6.0f) {
                            glyph = 95;
                        } else if (glyphWidth == 1.0f) {
                            glyph = 46;
                        }
                    }
                    if (oldGlyph != glyph) {
                        bakedglyph = glyphProvider.method_72736(glyph);
                    }
                }
                if (canDim && this.ticks % 3 != 1) {
                    dim = true;
                }
            }
            if (obfuscated && glyph != 32) {
                bakedglyph = glyphProvider.method_72737(this.textRenderer.field_2001, class_3532.method_15386((float)glyphWidth));
            }
            int drawColor = this.a;
            drawColor = textcolor != null ? (drawColor |= textcolor.method_27716()) : (dim ? (drawColor |= this.r * 192 >> 8 << 16 | this.g * 192 >> 8 << 8 | this.b * 192 >> 8) : (drawColor |= this.color));
            float f = standardWidth = this.section.wideFlaps ? 9.0f : 7.0f;
            if (this.section.renderCharsIndividually()) {
                this.x += (standardWidth - glyphWidth) / 2.0f;
            }
            if ((textDrawable = bakedglyph.method_73399(this.x, this.y, drawColor, 0, style, 0.0f, 0.0f)) != null) {
                this.consumer.accept((class_11767)textDrawable);
            }
            this.x = this.section.renderCharsIndividually() ? (this.x += standardWidth - (standardWidth - glyphWidth) / 2.0f) : (this.x += glyphWidth);
            return true;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class TextRenderState
    implements class_11659.class_11660 {
        public List<class_11767> glowingText = new ArrayList<class_11767>();
        public List<class_11767> normalText = new ArrayList<class_11767>();
        public int light;

        public TextRenderState(int light) {
            this.light = light;
        }

        public void add(boolean glowing, class_11767 textDrawable) {
            if (glowing) {
                this.glowingText.add(textDrawable);
            } else {
                this.normalText.add(textDrawable);
            }
        }

        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            Matrix4f pose = matricesEntry.method_23761();
            for (class_11767 glyph : this.glowingText) {
                glyph.method_73403(pose, vertexConsumer, 0xF000F0, true);
            }
            for (class_11767 glyph : this.normalText) {
                glyph.method_73403(pose, vertexConsumer, this.light, true);
            }
        }
    }
}

